/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * File: TEST.c
 *
 * Code generated for Simulink model 'TEST'.
 *
 * Model version                  : 1.2
 * Simulink Coder version         : 23.2 (R2023b) 01-Aug-2023
 * C/C++ source code generated on : Sun Jan 14 11:13:27 2024
 *
 * Target selection: ert.tlc
 * Embedded hardware selection: Atmel->AVR
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "TEST.h"
#include "TEST_private.h"
#include "rtwtypes.h"
#include <math.h>

/* Block signals (default storage) */
B_TEST_T TEST_B;

/* Block states (default storage) */
DW_TEST_T TEST_DW;

/* Real-time model */
static RT_MODEL_TEST_T TEST_M_;
RT_MODEL_TEST_T *const TEST_M = &TEST_M_;
real_T rt_roundd_snf(real_T u)
{
  real_T y;
  if (fabs(u) < 4.503599627370496E+15) {
    if (u >= 0.5) {
      y = floor(u + 0.5);
    } else if (u > -0.5) {
      y = u * 0.0;
    } else {
      y = ceil(u - 0.5);
    }
  } else {
    y = u;
  }

  return y;
}

/* Model step function */
void TEST_step(void)
{
  real_T y;
  int16_T idxDelay;
  uint8_T tmp;

  /* MATLABSystem: '<Root>/Digital Input2' */
  if (TEST_DW.obj.SampleTime != TEST_P.DigitalInput2_SampleTime) {
    TEST_DW.obj.SampleTime = TEST_P.DigitalInput2_SampleTime;
  }

  /* MATLABSystem: '<Root>/Digital Input2' */
  TEST_B.u = readDigitalPin(3);

  /* Sum: '<Root>/Add' incorporates:
   *  DataTypeConversion: '<Root>/Data Type Conversion1'
   *  Delay: '<Root>/Delay'
   *  RelationalOperator: '<S1>/FixPt Relational Operator'
   *  UnitDelay: '<S1>/Delay Input1'
   *
   * Block description for '<S1>/Delay Input1':
   *
   *  Store in Global RAM
   */
  TEST_DW.Delay_DSTATE += (real_T)((int16_T)TEST_B.u > (int16_T)
    TEST_DW.DelayInput1_DSTATE);

  /* Sum: '<Root>/Add1' incorporates:
   *  Delay: '<Root>/Delay'
   *  Delay: '<Root>/Delay1'
   */
  TEST_B.Add1 = TEST_DW.Delay_DSTATE - TEST_DW.Delay1_DSTATE[0];

  /* Product: '<Root>/Product2' incorporates:
   *  Constant: '<Root>/Constant2'
   *  Constant: '<Root>/Constant3'
   *  Constant: '<Root>/Constant4'
   *  Constant: '<Root>/Constant5'
   *  Constant: '<Root>/Constant6'
   *  Product: '<Root>/Divide1'
   *  Product: '<Root>/Divide2'
   *  Product: '<Root>/Product'
   *  Product: '<Root>/Product1'
   */
  TEST_B.Product2 = TEST_B.Add1 / (TEST_P.Constant2_Value *
    TEST_P.Constant3_Value) * TEST_P.Constant4_Value / TEST_P.Constant5_Value *
    TEST_P.Constant6_Value;

  /* Gain: '<Root>/Multiply1' incorporates:
   *  Constant: '<Root>/Constant'
   *  Gain: '<S2>/Slider Gain'
   */
  TEST_B.Multiply1 = TEST_P.SliderGain_gain * TEST_P.Constant_Value *
    TEST_P.Multiply1_Gain;

  /* MATLABSystem: '<Root>/Motor' */
  TEST_DW.obj_g.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle(11UL);

  /* Start for MATLABSystem: '<Root>/Motor' */
  if (TEST_B.Multiply1 <= 255.0) {
    y = TEST_B.Multiply1;
  } else {
    y = 255.0;
  }

  if (!(y >= 0.0)) {
    y = 0.0;
  }

  /* MATLABSystem: '<Root>/Motor' */
  MW_PWM_SetDutyCycle(TEST_DW.obj_g.PWMDriverObj.MW_PWM_HANDLE, y);

  /* ManualSwitch: '<Root>/Manual Switch' incorporates:
   *  Constant: '<Root>/Constant10'
   *  Constant: '<Root>/Constant8'
   */
  if (TEST_P.ManualSwitch_CurrentSetting == 1) {
    y = TEST_P.Constant8_Value;
  } else {
    y = TEST_P.Constant10_Value;
  }

  /* MATLABSystem: '<Root>/Digital Output1' incorporates:
   *  ManualSwitch: '<Root>/Manual Switch'
   */
  y = rt_roundd_snf(y);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(10, tmp);

  /* End of MATLABSystem: '<Root>/Digital Output1' */

  /* ManualSwitch: '<Root>/Manual Switch1' incorporates:
   *  Constant: '<Root>/Constant11'
   *  Constant: '<Root>/Constant9'
   */
  if (TEST_P.ManualSwitch1_CurrentSetting == 1) {
    y = TEST_P.Constant9_Value;
  } else {
    y = TEST_P.Constant11_Value;
  }

  /* MATLABSystem: '<Root>/Digital Output2' incorporates:
   *  ManualSwitch: '<Root>/Manual Switch1'
   */
  y = rt_roundd_snf(y);
  if (y < 256.0) {
    if (y >= 0.0) {
      tmp = (uint8_T)y;
    } else {
      tmp = 0U;
    }
  } else {
    tmp = MAX_uint8_T;
  }

  writeDigitalPin(9, tmp);

  /* End of MATLABSystem: '<Root>/Digital Output2' */

  /* Update for UnitDelay: '<S1>/Delay Input1'
   *
   * Block description for '<S1>/Delay Input1':
   *
   *  Store in Global RAM
   */
  TEST_DW.DelayInput1_DSTATE = TEST_B.u;

  /* Update for Delay: '<Root>/Delay1' incorporates:
   *  Delay: '<Root>/Delay'
   */
  for (idxDelay = 0; idxDelay < 99; idxDelay++) {
    TEST_DW.Delay1_DSTATE[idxDelay] = TEST_DW.Delay1_DSTATE[idxDelay + 1];
  }

  TEST_DW.Delay1_DSTATE[99] = TEST_DW.Delay_DSTATE;

  /* End of Update for Delay: '<Root>/Delay1' */
  {                                    /* Sample time: [0.0005s, 0.0s] */
  }

  /* Update absolute time for base rate */
  /* The "clockTick0" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick0"
   * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
   * overflow during the application lifespan selected.
   */
  TEST_M->Timing.taskTime0 =
    ((time_T)(++TEST_M->Timing.clockTick0)) * TEST_M->Timing.stepSize0;
}

/* Model initialize function */
void TEST_initialize(void)
{
  /* Registration code */
  rtmSetTFinal(TEST_M, -1);
  TEST_M->Timing.stepSize0 = 0.0005;

  /* External mode info */
  TEST_M->Sizes.checksums[0] = (4017926310U);
  TEST_M->Sizes.checksums[1] = (2088335490U);
  TEST_M->Sizes.checksums[2] = (1775650178U);
  TEST_M->Sizes.checksums[3] = (385443865U);

  {
    static const sysRanDType rtAlwaysEnabled = SUBSYS_RAN_BC_ENABLE;
    static RTWExtModeInfo rt_ExtModeInfo;
    static const sysRanDType *systemRan[9];
    TEST_M->extModeInfo = (&rt_ExtModeInfo);
    rteiSetSubSystemActiveVectorAddresses(&rt_ExtModeInfo, systemRan);
    systemRan[0] = &rtAlwaysEnabled;
    systemRan[1] = &rtAlwaysEnabled;
    systemRan[2] = &rtAlwaysEnabled;
    systemRan[3] = &rtAlwaysEnabled;
    systemRan[4] = &rtAlwaysEnabled;
    systemRan[5] = &rtAlwaysEnabled;
    systemRan[6] = &rtAlwaysEnabled;
    systemRan[7] = &rtAlwaysEnabled;
    systemRan[8] = &rtAlwaysEnabled;
    rteiSetModelMappingInfoPtr(TEST_M->extModeInfo,
      &TEST_M->SpecialInfo.mappingInfo);
    rteiSetChecksumsPtr(TEST_M->extModeInfo, TEST_M->Sizes.checksums);
    rteiSetTPtr(TEST_M->extModeInfo, rtmGetTPtr(TEST_M));
  }

  {
    int16_T i;

    /* InitializeConditions for UnitDelay: '<S1>/Delay Input1'
     *
     * Block description for '<S1>/Delay Input1':
     *
     *  Store in Global RAM
     */
    TEST_DW.DelayInput1_DSTATE = TEST_P.DetectIncrease_vinit;

    /* InitializeConditions for Delay: '<Root>/Delay' */
    TEST_DW.Delay_DSTATE = TEST_P.Delay_InitialCondition;

    /* InitializeConditions for Delay: '<Root>/Delay1' */
    for (i = 0; i < 100; i++) {
      TEST_DW.Delay1_DSTATE[i] = TEST_P.Delay1_InitialCondition;
    }

    /* End of InitializeConditions for Delay: '<Root>/Delay1' */

    /* Start for MATLABSystem: '<Root>/Digital Input2' */
    TEST_DW.obj.matlabCodegenIsDeleted = false;
    TEST_DW.obj.SampleTime = TEST_P.DigitalInput2_SampleTime;
    TEST_DW.obj.isInitialized = 1L;
    digitalIOSetup(3, 0);
    TEST_DW.obj.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Motor' */
    TEST_DW.obj_g.matlabCodegenIsDeleted = false;
    TEST_DW.obj_g.isInitialized = 1L;
    TEST_DW.obj_g.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_Open(11UL, 0.0, 0.0);
    TEST_DW.obj_g.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Digital Output1' */
    TEST_DW.obj_j.matlabCodegenIsDeleted = false;
    TEST_DW.obj_j.isInitialized = 1L;
    digitalIOSetup(10, 1);
    TEST_DW.obj_j.isSetupComplete = true;

    /* Start for MATLABSystem: '<Root>/Digital Output2' */
    TEST_DW.obj_b.matlabCodegenIsDeleted = false;
    TEST_DW.obj_b.isInitialized = 1L;
    digitalIOSetup(9, 1);
    TEST_DW.obj_b.isSetupComplete = true;
  }
}

/* Model terminate function */
void TEST_terminate(void)
{
  /* Terminate for MATLABSystem: '<Root>/Digital Input2' */
  if (!TEST_DW.obj.matlabCodegenIsDeleted) {
    TEST_DW.obj.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/Digital Input2' */
  /* Terminate for MATLABSystem: '<Root>/Motor' */
  if (!TEST_DW.obj_g.matlabCodegenIsDeleted) {
    TEST_DW.obj_g.matlabCodegenIsDeleted = true;
    if ((TEST_DW.obj_g.isInitialized == 1L) && TEST_DW.obj_g.isSetupComplete) {
      TEST_DW.obj_g.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle(11UL);
      MW_PWM_SetDutyCycle(TEST_DW.obj_g.PWMDriverObj.MW_PWM_HANDLE, 0.0);
      TEST_DW.obj_g.PWMDriverObj.MW_PWM_HANDLE = MW_PWM_GetHandle(11UL);
      MW_PWM_Close(TEST_DW.obj_g.PWMDriverObj.MW_PWM_HANDLE);
    }
  }

  /* End of Terminate for MATLABSystem: '<Root>/Motor' */
  /* Terminate for MATLABSystem: '<Root>/Digital Output1' */
  if (!TEST_DW.obj_j.matlabCodegenIsDeleted) {
    TEST_DW.obj_j.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/Digital Output1' */

  /* Terminate for MATLABSystem: '<Root>/Digital Output2' */
  if (!TEST_DW.obj_b.matlabCodegenIsDeleted) {
    TEST_DW.obj_b.matlabCodegenIsDeleted = true;
  }

  /* End of Terminate for MATLABSystem: '<Root>/Digital Output2' */
}

/*
 * File trailer for generated code.
 *
 * [EOF]
 */
